require( "scripts/style.lua" );


MyFont = {
  standardFont,
  30,
  BlackColor
}

NameFont = {
  standardFont,
  24,
  BlackColor
}

local playername = gEnterNameValue;




MakeDialog
{
	Bitmap
	{ 
		image="backgrounds/dialog",
		x=kCenter,
		y=kCenter,
		
		EnterNameWindow
		{
			x=0,y=20,w=kMax,h=kMax,
			Text
			{
				font = MyFont,
				name = "entername",
				label = "entername",
				x=0,y=180,w=kMax,h=30,				
				flags = kHAlignCenter + kVAlignTop,
			};
			
			Bitmap
			{
				image="backgrounds/textfield.png",
				x=kCenter,
				y=240,
				
				TextEdit
				{
					font = NameFont,
					name = "nameedit",
					label = playername,
					x=7,y=18,w=kMax-3,h=kMax,
					length=20,
					ignore = kIllegalNameChars
					
				};
			};
			
			Button
			{
				x=40, y=40,         -- Position of the button
				--label="Start Game", -- Button text
				command=
						function()
							SwapToModal("gamescreen.lua");  -- switch to the game screen
						end;
			};
			
			Button
			{
				x=kCenter-75,
				y=340,
				font = NameFont,
				graphics = StandardButtonGraphics,
				name="enterok",
				label="ok",
				default = true,
				type = kPush,
				rolloversound = "assets/audio/sfx/dialog_roll.ogg",
				sound = "assets/audio/sfx/dialog_click.ogg",
				command = 
					function()
						if (IsNameInUse(GetLabel("nameedit"))) then
							DisplayDialog { 
								"scripts/ok.lua", 
								body ="nameinuse",
								title = ""
							};
							SetFocus( "nameedit" )
						else
							CloseWindow(GetLabel("nameedit"));
						end
					end
			},
			
			Button
			{
				x=kCenter+75,
				y=340,
				font = StandardButtonFont,
				graphics = StandardButtonGraphics,
				name="entercancel",
				label="cancel",
				type = kPush,
				rolloversound = "assets/audio/sfx/dialog_roll.ogg",
				sound = "assets/audio/sfx/dialog_click.ogg",
				command = 
					function()
						CloseWindow(nil);
					end
			};
		}
		
	},
	
	SetFocus( "nameedit" )
}



